define(['backbone'], function (Backbone) {
    'use strict';

    return Backbone.Model.extend({
        initialize: function () {
            if (!this.has('id') && this.has('title')) {
                this.id = this.get('title');
            } else if (this.get('rel') === 'self') {
                this.id = 'self';
                this.set('title', 'self');
            }
        },

        // eslint-disable-next-line consistent-return
        validate: function () {
            if (!this.get('title')) {
                return 'title is a required field';
            }
            if (!this.get('href')) {
                return 'href is a required field';
            }
        },
        // ex. for href: "patient/{assigning-authority}/{patient-id}",
        // given attributes: { 'assigning-authority': '', 'patient-id': '8' }
        // returns href with replaced {attribute-name}'s
        formatHref: function (attributes) {
            var href = this.get('href');

            return href.replace(/{(\w+(-\w+)*)}/g, function(match, attributeName) {
                return typeof attributes[attributeName] !== 'undefined' ? attributes[attributeName] : attributeName;
            });
        },
    });
});
